/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.config.MutationCommonConfig;
import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.enums.MobMutations;
import com.alexander.mutantmore.events.ShakeCameraEvent;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.ParticleTypeInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.interfaces.IMutatable;
import com.alexander.mutantmore.util.HandleLoopingSoundInstances;
import com.alexander.mutantmore.util.MiscUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutationEffect
extends Entity
implements IAnimatable,
IAnimationTickable {
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.m_135353_(MutationEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TARGET_ENTITY_ID = SynchedEntityData.m_135353_(MutationEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ATTACHED = SynchedEntityData.m_135353_(MutationEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public final TargetingConditions targeting = TargetingConditions.m_148353_().m_26883_(12.0).m_148355_().m_26893_().m_26888_(entity -> this.f_19853_ == entity.f_19853_ && EntitySelector.f_20406_.test(entity) && entity.m_6095_() != EntityType.f_20529_ && !entity.m_20147_() && !entity.m_21224_() && this.f_19853_.m_6857_().m_61935_(entity.m_20191_()) && this.canTarget((LivingEntity)entity));
    public int mutationTicks;
    public int failTicks;
    public int lifeTime;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    public boolean mutatedMob = false;

    public MutationEffect(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.lifeTime = 200;
    }

    public MutationEffect(Level worldIn, Mob target, boolean charged) {
        this((EntityType)EntityTypeInit.MUTATION_EFFECT.get(), worldIn);
        this.setCharged(charged);
        this.setTarget(target);
        this.lifeTime = 200;
    }

    public void setOwner(@Nullable Entity p_37263_) {
        if (p_37263_ != null) {
            this.ownerUUID = p_37263_.m_20148_();
            this.cachedOwner = p_37263_;
        }
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.f_19853_ instanceof ServerLevel) {
            this.cachedOwner = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public EntityDimensions m_6972_(Pose p_19975_) {
        float scaleAddition = 0.0f;
        if (this.getTarget() != null && this.isAttached()) {
            scaleAddition = this.getTarget().m_20205_() >= this.getTarget().m_20206_() ? this.getTarget().m_20205_() : this.getTarget().m_20206_();
        }
        return (Boolean)MutationCommonConfig.classic_mutations.get() == false ? super.m_6972_(p_19975_).m_20388_(1.0f + (scaleAddition - 1.0f)) : EntityDimensions.m_20395_((float)(this.getTarget() != null && this.isAttached() ? this.getTarget().m_20205_() : 0.0f), (float)(this.getTarget() != null && this.isAttached() ? this.getTarget().m_20206_() : 0.0f));
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.f_19853_.f_46443_) {
            HandleLoopingSoundInstances.addMutationEffectAudio(this, this.f_19853_);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            ShakeCameraEvent.shake(this.f_19853_, 2, this.isCharged() ? 0.03f : 0.015f, this.m_20183_(), 35, CameraShakePriority.EFFECT);
        }
        this.m_6210_();
        for (MutationEffect mutationEffect : this.getNearbyMutationEffects()) {
            if (mutationEffect == this || mutationEffect.getTarget() != this.getTarget() || !mutationEffect.isAttached()) continue;
            this.setTarget(this.findNearestTargetableMob());
        }
        if (!(this.mutationTicks <= 10 && this.failTicks <= 10 || ((Boolean)MutationCommonConfig.classic_mutations.get()).booleanValue())) {
            for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(5.0))) {
                if (this.getTarget() != null && livingentity == this.getTarget()) continue;
                double d0 = livingentity.m_20185_() - this.m_20185_();
                double d1 = livingentity.m_20189_() - this.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                livingentity.m_5997_(d0 / d2 * 0.5, 0.0, d1 / d2 * 0.5);
            }
        }
        if (!this.f_19853_.f_46443_ && this.getTarget() != null && this.isAttached()) {
            if (this.mutationTicks == 10) {
                if (((Boolean)MutationCommonConfig.classic_mutations.get()).booleanValue()) {
                    MiscUtils.customExplosion(this.f_19853_, null, DamageSource.m_19373_((LivingEntity)null).m_181120_(), null, this.getTarget().m_20185_(), this.getTarget().m_20186_() + (double)(this.getTarget().m_20206_() / 2.0f), this.getTarget().m_20189_(), this.isCharged() ? 6.0f : 3.0f, false, Explosion.BlockInteraction.NONE, SoundEvents.f_11913_, this.getTarget().m_5720_(), (ParticleOptions)ParticleTypes.f_123812_, (ParticleOptions)ParticleTypes.f_123813_, 0.0f, false, false);
                }
                if (MobMutations.byBaseMob((Mob)this.getTarget()).createdEntityType != null) {
                    this.convertMobToMutant(this.getTarget(), MobMutations.byBaseMob((Mob)this.getTarget()).createdEntityType);
                } else if (MobMutations.byBaseMob((Mob)this.getTarget()).createdLazyEntityType != null) {
                    this.convertMobToMutant(this.getTarget(), (EntityType)MobMutations.byBaseMob((Mob)this.getTarget()).createdLazyEntityType);
                }
                if (this.getOwner() != null && this.getOwner() instanceof ServerPlayer) {
                    MiscUtils.awardMutantMoreAdvancement((ServerPlayer)this.getOwner(), "nether/mutate_mob", "mutated");
                }
            }
            if (this.failTicks == 10) {
                if (((Boolean)MutationCommonConfig.classic_mutations.get()).booleanValue()) {
                    MiscUtils.customExplosion(this.f_19853_, null, DamageSource.m_19373_((LivingEntity)null).m_181120_(), null, this.getTarget().m_20185_(), this.getTarget().m_20186_() + (double)(this.getTarget().m_20206_() / 2.0f), this.getTarget().m_20189_(), this.isCharged() ? 4.0f : 2.0f, false, Explosion.BlockInteraction.NONE, SoundEvents.f_11913_, this.getTarget().m_5720_(), (ParticleOptions)ParticleTypes.f_123812_, (ParticleOptions)ParticleTypes.f_123813_, 0.0f, false, false);
                }
                this.getTarget().m_6469_(DamageSource.f_19319_, this.isCharged() ? 20.0f : 10.0f);
            }
        }
        if (!(this.f_19853_.f_46443_ || this.failTicks != 1 && this.mutationTicks != 1)) {
            this.m_146870_();
        }
        if (this.mutationTicks > 0) {
            --this.mutationTicks;
        }
        if (this.failTicks > 0) {
            --this.failTicks;
        }
        if (!this.f_19853_.f_46443_ && this.getTarget() == null) {
            if (this.lifeTime > 0) {
                --this.lifeTime;
            } else {
                this.m_146870_();
            }
        }
        if (this.getTarget() == null && !this.f_19853_.f_46443_) {
            this.setAttached(false);
            this.failTicks = 0;
            this.f_19853_.m_7605_((Entity)this, (byte)1);
        }
        if (this.getTarget() != null) {
            if (this.isAttached()) {
                if (this.f_19796_.m_188503_(10) == 0) {
                    this.getTarget().m_6469_(DamageSource.f_19319_, 0.0f);
                }
                if (!((Boolean)MutationCommonConfig.classic_mutations.get()).booleanValue()) {
                    this.getTarget().m_20256_(new Vec3(0.0, 0.0, 0.0));
                    this.getTarget().m_6710_(null);
                } else {
                    this.getTarget().m_146884_(this.getTarget().m_20182_().m_82520_(this.f_19796_.m_188583_() * 0.02, 0.0, this.f_19796_.m_188583_() * 0.02));
                }
                this.m_6034_(this.getTarget().m_20185_(), this.getTarget().m_20186_(), this.getTarget().m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.createShadowSwirlParticle();
                    this.createEnergyPopParticle();
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)0);
                }
            } else if (!this.mutatedMob) {
                if (this.f_19853_.f_46443_) {
                    this.createShadowSwirlParticle();
                    this.createEnergyPopParticle();
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)0);
                }
                this.f_19790_ = this.m_20185_();
                this.f_19791_ = this.m_20186_();
                this.f_19792_ = this.m_20189_();
                this.m_20334_(0.0, 0.0, 0.0);
                double x = this.getTarget().m_20185_() - this.m_20185_();
                double y = this.getTarget().m_20186_() - this.m_20186_();
                double z = this.getTarget().m_20189_() - this.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                this.m_20256_(this.m_20184_().m_82520_(x / d * (this.isCharged() ? (Double)MutationCommonConfig.compound_z_cloud_movement_speed.get() : (Double)MutationCommonConfig.formula_y_cloud_movement_speed.get()), y / d * (this.isCharged() ? (Double)MutationCommonConfig.compound_z_cloud_movement_speed.get() : (Double)MutationCommonConfig.formula_y_cloud_movement_speed.get()), z / d * (this.isCharged() ? (Double)MutationCommonConfig.compound_z_cloud_movement_speed.get() : (Double)MutationCommonConfig.formula_y_cloud_movement_speed.get())));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (!this.f_19853_.f_46443_ && (double)this.m_20270_((Entity)this.getTarget()) < 2.0) {
                    if (MobMutations.byBaseMob((Mob)this.getTarget()).createdEntityType != null || MobMutations.byBaseMob((Mob)this.getTarget()).createdLazyEntityType != null) {
                        if (this.isCharged() && MiscUtils.randomPercent((Integer)MutationCommonConfig.compound_z_mutate_chance.get()) || !this.isCharged() && MiscUtils.randomPercent((Integer)MutationCommonConfig.formula_y_mutate_chance.get())) {
                            if (!((Boolean)MutationCommonConfig.classic_mutations.get()).booleanValue()) {
                                this.mutationTicks = 335;
                                this.m_5496_((SoundEvent)SoundEventInit.SUCCESSFUL_MUTATION.get(), 3.0f, 1.0f);
                                this.f_19853_.m_7605_((Entity)this, (byte)2);
                            } else {
                                this.mutationTicks = (Integer)MutationCommonConfig.classic_mutation_min_time.get() + this.f_19796_.m_188503_((Integer)MutationCommonConfig.classic_mutation_max_time.get() - (Integer)MutationCommonConfig.classic_mutation_min_time.get());
                            }
                        } else if (!((Boolean)MutationCommonConfig.classic_mutations.get()).booleanValue()) {
                            this.failTicks = 160;
                            this.m_5496_((SoundEvent)SoundEventInit.FAILED_MUTATION.get(), 3.0f, 1.0f);
                            this.f_19853_.m_7605_((Entity)this, (byte)3);
                        } else {
                            this.failTicks = (Integer)MutationCommonConfig.classic_mutation_min_time.get() + this.f_19796_.m_188503_((Integer)MutationCommonConfig.classic_mutation_max_time.get() - (Integer)MutationCommonConfig.classic_mutation_min_time.get());
                        }
                    } else if (!((Boolean)MutationCommonConfig.classic_mutations.get()).booleanValue()) {
                        this.failTicks = 160;
                        this.m_5496_((SoundEvent)SoundEventInit.FAILED_MUTATION.get(), 3.0f, 1.0f);
                        this.f_19853_.m_7605_((Entity)this, (byte)3);
                    } else {
                        this.failTicks = (Integer)MutationCommonConfig.classic_mutation_min_time.get() + this.f_19796_.m_188503_((Integer)MutationCommonConfig.classic_mutation_max_time.get() - (Integer)MutationCommonConfig.classic_mutation_min_time.get());
                    }
                    this.setAttached(true);
                }
            }
        } else {
            if (this.f_19853_.f_46443_) {
                this.createShadowSwirlParticle();
                this.createEnergyPopParticle();
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)0);
            }
            if (this.findNearestTargetableMob() != null) {
                this.setTarget(this.findNearestTargetableMob());
            }
        }
    }

    public void convertMobToMutant(Mob originalMob, EntityType<?> createdEntityType) {
        if (!originalMob.f_19853_.f_46443_) {
            Mob mutant = originalMob.m_21406_(createdEntityType, true);
            ForgeEventFactory.onLivingConvert((LivingEntity)originalMob, (LivingEntity)mutant);
            mutant.m_6518_((ServerLevelAccessor)((ServerLevel)mutant.f_19853_), mutant.f_19853_.m_6436_(mutant.m_20183_()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
            Player nearbyPlayer = mutant.f_19853_.m_45930_((Entity)mutant, 35.0);
            if (nearbyPlayer != null) {
                mutant.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(nearbyPlayer.m_20185_(), nearbyPlayer.m_20188_(), nearbyPlayer.m_20189_()));
            }
            if (mutant instanceof IMutatable) {
                ((IMutatable)mutant).onMutated();
            }
        }
    }

    public Mob findNearestTargetableMob() {
        List availableTargets = this.f_19853_.m_45971_(Mob.class, this.targeting, null, this.m_20191_().m_82377_(((Double)MutationCommonConfig.mutation_cloud_search_range.get()).doubleValue(), ((Double)MutationCommonConfig.mutation_cloud_search_range_y.get()).doubleValue(), ((Double)MutationCommonConfig.mutation_cloud_search_range.get()).doubleValue()));
        Mob chosenTarget = (Mob)this.f_19853_.m_45963_(Mob.class, this.targeting, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82377_(((Double)MutationCommonConfig.mutation_cloud_search_range.get()).doubleValue(), ((Double)MutationCommonConfig.mutation_cloud_search_range_y.get()).doubleValue(), ((Double)MutationCommonConfig.mutation_cloud_search_range.get()).doubleValue()));
        for (Mob target : availableTargets) {
            for (MutationEffect mutationEffect : this.getNearbyMutationEffects()) {
                if (mutationEffect == this || mutationEffect.getTarget() != chosenTarget || !mutationEffect.isAttached()) continue;
                chosenTarget = null;
                if (mutationEffect != this && mutationEffect.getTarget() == target && mutationEffect.isAttached()) {
                    target = null;
                    continue;
                }
                chosenTarget = target;
            }
        }
        return chosenTarget;
    }

    public List<MutationEffect> getNearbyMutationEffects() {
        return MiscUtils.getNearbyNonLivingEntities(MutationEffect.class, this.f_19853_, this, this.m_20191_().m_82400_(12.0));
    }

    public void createShadowSwirlParticle() {
        double d0 = this.f_19796_.m_188583_() * 0.15;
        double d1 = this.f_19796_.m_188583_() * 0.15;
        double d2 = this.f_19796_.m_188583_() * 0.15;
        this.f_19853_.m_7107_((ParticleOptions)ParticleTypeInit.SHADOW_SWIRL.get(), this.m_20208_(1.25), this.m_20187_(), this.m_20262_(1.25), d0, d1, d2);
    }

    public void createEnergyPopParticle() {
        if (this.isCharged()) {
            double d0 = this.f_19796_.m_188583_() * 0.25;
            double d1 = this.f_19796_.m_188583_() * 0.25;
            double d2 = this.f_19796_.m_188583_() * 0.25;
            this.f_19853_.m_7107_((ParticleOptions)ParticleTypeInit.ENERGY_POP.get(), this.m_20208_(1.25), this.m_20187_(), this.m_20262_(1.25), d0, d1, d2);
        }
    }

    public void m_7822_(byte p_36869_) {
        if (p_36869_ == 0) {
            this.createShadowSwirlParticle();
            this.createEnergyPopParticle();
        } else if (p_36869_ == 1) {
            this.failTicks = 0;
        } else if (p_36869_ == 2) {
            this.mutationTicks = 335;
        } else if (p_36869_ == 3) {
            this.failTicks = 160;
        } else {
            super.m_7822_(p_36869_);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_ENTITY_ID, (Object)0);
        this.f_19804_.m_135372_(ATTACHED, (Object)false);
        this.f_19804_.m_135372_(CHARGED, (Object)false);
    }

    protected void m_7380_(CompoundTag p_37265_) {
        if (this.ownerUUID != null) {
            p_37265_.m_128362_("Owner", this.ownerUUID);
        }
    }

    protected boolean ownedBy(Entity p_150172_) {
        return p_150172_.m_20148_().equals(this.ownerUUID);
    }

    protected void m_7378_(CompoundTag p_37262_) {
        if (p_37262_.m_128403_("Owner")) {
            this.ownerUUID = p_37262_.m_128342_("Owner");
        }
    }

    public boolean isAttached() {
        return (Boolean)this.f_19804_.m_135370_(ATTACHED);
    }

    public void setAttached(boolean attached) {
        if (attached) {
            this.mutatedMob = true;
        }
        this.f_19804_.m_135381_(ATTACHED, (Object)attached);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.lifeTime = charged ? 300 : 200;
        this.f_19804_.m_135381_(CHARGED, (Object)charged);
    }

    public Mob getTarget() {
        Entity target = this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ENTITY_ID)).intValue());
        return target instanceof Mob ? (Mob)target : null;
    }

    private void setTarget(Mob entity) {
        if (entity != null) {
            this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)entity.m_19879_());
        } else {
            this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)0);
        }
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean canTarget(LivingEntity target) {
        return !target.m_6095_().m_204039_(TagInit.EntityTypes.MUTATION_CLOUD_CANT_AIM_FOR);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.mutationTicks > 0 && !((Boolean)MutationCommonConfig.classic_mutations.get()).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutation_effect_mutate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.failTicks > 0 && !((Boolean)MutationCommonConfig.classic_mutations.get()).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutation_effect_fail", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutation_effect_seeking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

